from utils import *

try:
    n, t, d, sd = get_params_from_arguments()
    print('n, t, d, sd = {}'.format((n, t, d, sd)))
except:
    print('===== Not parsing input arguments & using default values =====')
    n, t, d, sd = 50, 100, 10, 1

B, alpha, const = create_inf_dim_market(n, d, sd=2022)
t_list = np.arange(100, 5100, 100)

np.random.seed(sd)
nsw_list = []
for t in t_list:
    v_mat = sample_market_instance(alpha, const, t)
    x_eq, p_eq = compute_me_fin_dim(v_mat, B, max_iter=5000)
    u_eq = (v_mat * x_eq).sum(axis=1)
    nsw = (B * np.log(u_eq)).sum()
    print(f'seed={sd}, t={t}, nsw={nsw}')
    nsw_list.append(nsw)
    np.savez_compressed(
        f'results/nsw_list_n_{n}_d_{d}_sd_{sd}', 
        t_list=t_list, 
        nsw_list=nsw_list
    )